/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.gui;

import de.quippy.javamod.main.gui.JavaModAbout;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.gui.SimpleTextViewerDialog;
import de.quippy.javamod.main.gui.UrlDialog;
import de.quippy.javamod.main.gui.components.LEDScrollPanel;
import de.quippy.javamod.main.gui.components.RoundSlider;
import de.quippy.javamod.main.gui.components.SAMeterPanel;
import de.quippy.javamod.main.gui.components.SeekBarPanel;
import de.quippy.javamod.main.gui.components.VUMeterPanel;
import de.quippy.javamod.main.gui.filechooser.FileChooserFilter;
import de.quippy.javamod.main.gui.filechooser.FileChooserResult;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.mixer.dsp.DspProcessorCallBack;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerEvent;
import de.quippy.javamod.multimedia.MultimediaContainerEventListener;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import de.quippy.javamod.system.LogMessageCallBack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainForm
extends JFrame
implements LogMessageCallBack,
DspProcessorCallBack,
PlayThreadEventListener,
MultimediaContainerEventListener {
    private static final long serialVersionUID = -2737074464335059959L;
    private static final String DEFAULTICONPATH = "/de/quippy/javamod/main/gui/ressources/quippy_the_kangaroo_icon.gif";
    public static final String BUTTONPLAY_INACTIVE = "/de/quippy/javamod/main/gui/ressources/play.gif";
    public static final String BUTTONPLAY_ACTIVE = "/de/quippy/javamod/main/gui/ressources/play_aktiv.gif";
    public static final String BUTTONPLAY_NORMAL = "/de/quippy/javamod/main/gui/ressources/play_normal.gif";
    public static final String BUTTONPAUSE_INACTIVE = "/de/quippy/javamod/main/gui/ressources/pause.gif";
    public static final String BUTTONPAUSE_ACTIVE = "/de/quippy/javamod/main/gui/ressources/pause_aktiv.gif";
    public static final String BUTTONPAUSE_NORMAL = "/de/quippy/javamod/main/gui/ressources/pause_normal.gif";
    public static final String BUTTONSTOP_INACTIVE = "/de/quippy/javamod/main/gui/ressources/stop.gif";
    public static final String BUTTONSTOP_ACTIVE = "/de/quippy/javamod/main/gui/ressources/stop_aktiv.gif";
    public static final String BUTTONSTOP_NORMAL = "/de/quippy/javamod/main/gui/ressources/stop_normal.gif";
    public static final String BUTTONPREV_INACTIVE = "/de/quippy/javamod/main/gui/ressources/prev.gif";
    public static final String BUTTONPREV_ACTIVE = "/de/quippy/javamod/main/gui/ressources/prev_aktiv.gif";
    public static final String BUTTONPREV_NORMAL = "/de/quippy/javamod/main/gui/ressources/prev_normal.gif";
    public static final String BUTTONNEXT_INACTIVE = "/de/quippy/javamod/main/gui/ressources/next.gif";
    public static final String BUTTONNEXT_ACTIVE = "/de/quippy/javamod/main/gui/ressources/next_aktiv.gif";
    public static final String BUTTONNEXT_NORMAL = "/de/quippy/javamod/main/gui/ressources/next_normal.gif";
    private static final String PROPERTYFILENAME = ".javamod.properties";
    private static final String PROPERTY_SEARCHPATH = "javamod.path.loadpath";
    private static final String PROPERTY_EXPORTPATH = "javamod.path.exportpath";
    private static final String PROPERTY_LOOKANDFEEL = "javamod.lookandfeel.classname";
    private static final String PROPERTY_LASTLOADED = "javamod.path.lastloaded";
    private static final String PROPERTY_MAINDIALOG_POS = "javamod.dialog.position.main";
    private static final String PROPERTY_SETUPDIALOG_POS = "javamod.dialog.position.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_POS = "javamod.dialog.position.properties";
    private static final String PROPERTY_MAINDIALOG_SIZE = "javamod.dialog.size.main";
    private static final String PROPERTY_SETUPDIALOG_SIZE = "javamod.dialog.size.setup";
    private static final String PROPERTY_PROPERTIESDIALOG_SIZE = "javamod.dialog.size.properties";
    private static final String PROPERTY_VOLUME_VALUE = "javamod.dialog.volume.value";
    private static final String PROPERTY_BALANCE_VALUE = "javamod.dialog.balance.value";
    private static final int PROPERTY_LASTLOADED_MAXENTRIES = 10;
    private static final String WINDOW_TITLE = "Java Mod Player V1.9.3.4";
    private static final String WINDOW_NAME = "JavaMod";
    private static FileFilter[] fileFilterExport;
    private static FileFilter[] fileFilterLoad;
    private ImageIcon buttonPlay_Active = null;
    private ImageIcon buttonPlay_Inactive = null;
    private ImageIcon buttonPlay_normal = null;
    private ImageIcon buttonPause_Active = null;
    private ImageIcon buttonPause_Inactive = null;
    private ImageIcon buttonPause_normal = null;
    private ImageIcon buttonStop_Active = null;
    private ImageIcon buttonStop_Inactive = null;
    private ImageIcon buttonStop_normal = null;
    private ImageIcon buttonPrev_Active = null;
    private ImageIcon buttonPrev_Inactive = null;
    private ImageIcon buttonPrev_normal = null;
    private ImageIcon buttonNext_Active = null;
    private ImageIcon buttonNext_Inactive = null;
    private ImageIcon buttonNext_normal = null;
    private JButton button_Play = null;
    private JButton button_Pause = null;
    private JButton button_Stop = null;
    private JButton button_Prev = null;
    private JButton button_Next = null;
    private RoundSlider volumeSlider = null;
    private JLabel volumeLabel = null;
    private RoundSlider balanceSlider = null;
    private JLabel balanceLabel = null;
    private JPanel baseContentPane = null;
    private JPanel mainContentPane = null;
    private JPanel musicDataPane = null;
    private JPanel playerControlPane = null;
    private JPanel playerDataPane = null;
    private JDialog modInfoDialog = null;
    private JDialog playerSetUpDialog = null;
    private JPanel playerSetUpPane = null;
    private JPanel modInfoPane = null;
    private Point mainDialogLocation = null;
    private Dimension mainDialogSize = null;
    private Point modInfoDialogLocation = null;
    private Dimension modInfoDialogSize = null;
    private Point playerSetUpDialogLocation = null;
    private Dimension playerSetUpDialogSize = null;
    private JDialog downloadDialog = null;
    private JPanel downloadPane = null;
    private JProgressBar downloadProgressBar = null;
    private VUMeterPanel vuLMeterPanel = null;
    private VUMeterPanel vuRMeterPanel = null;
    private SAMeterPanel saLMeterPanel = null;
    private SAMeterPanel saRMeterPanel = null;
    private LEDScrollPanel ledScrollPanel = null;
    private SeekBarPanel seekBarPanel = null;
    private JTextField messages = null;
    private JMenuBar baseMenuBar = null;
    private JMenu menu_File = null;
    private JMenu menu_View = null;
    private JMenu menu_LookAndFeel = null;
    private JMenu menu_Help = null;
    private JMenu menu_File_RecentFiles = null;
    private JMenuItem menu_File_openMod = null;
    private JMenuItem menu_File_openURL = null;
    private JMenuItem menu_File_exportWave = null;
    private JMenuItem menu_File_Close = null;
    private JMenuItem menu_View_Info = null;
    private JMenuItem menu_View_Setup = null;
    private JMenuItem menu_Help_CheckUpdate = null;
    private JMenuItem menu_Help_ShowVersionHistory = null;
    private JMenuItem menu_Help_About = null;
    private JCheckBoxMenuItem[] menu_LookAndFeel_Items = null;
    private JavaModAbout about = null;
    private UrlDialog urlDialog = null;
    private SimpleTextViewerDialog simpleTextViewerDialog = null;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread;
    private PlayList currentPlayList = null;
    private ArrayList<DropTarget> dropTargetList;
    private AudioProcessor audioProcessor;
    private String propertyFilePath = System.getProperty("user.home");
    private String searchPath;
    private String exportPath;
    private String uiClassName;
    private float currentVolume;
    private float currentBalance;
    private ArrayList<URL> lastLoaded;

    public MainForm() {
        this.initialize();
    }

    private void readPropertyFile() {
        Properties props = new Properties();
        try {
            File propertyFile = new File(String.valueOf(this.propertyFilePath) + File.separator + PROPERTYFILENAME);
            if (propertyFile.exists()) {
                FileInputStream fis = new FileInputStream(propertyFile);
                props.load(fis);
            }
            this.searchPath = props.getProperty(PROPERTY_SEARCHPATH, System.getProperty("user.home"));
            this.exportPath = props.getProperty(PROPERTY_EXPORTPATH, System.getProperty("user.home"));
            this.uiClassName = props.getProperty(PROPERTY_LOOKANDFEEL, UIManager.getSystemLookAndFeelClassName());
            this.currentVolume = Float.parseFloat(props.getProperty(PROPERTY_VOLUME_VALUE, "1.0"));
            this.currentBalance = Float.parseFloat(props.getProperty(PROPERTY_BALANCE_VALUE, "0.0"));
            this.lastLoaded = new ArrayList(10);
            int i = 0;
            while (i < 10) {
                String url = props.getProperty("javamod.path.lastloaded." + i, null);
                if (url != null) {
                    this.lastLoaded.add(new URL(url));
                } else {
                    this.lastLoaded.add(null);
                }
                ++i;
            }
            this.mainDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_MAINDIALOG_POS, "-1x-1"));
            this.mainDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_MAINDIALOG_SIZE, "-1x-1"));
            this.playerSetUpDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_SETUPDIALOG_POS, "-1x-1"));
            this.playerSetUpDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_SETUPDIALOG_SIZE, "-1x-1"));
            this.modInfoDialogLocation = Helpers.getPointFromString(props.getProperty(PROPERTY_PROPERTIESDIALOG_POS, "-1x-10"));
            this.modInfoDialogSize = Helpers.getDimensionFromString(props.getProperty(PROPERTY_PROPERTIESDIALOG_SIZE, "-1x-10"));
            MultimediaContainerManager.configureContainer(props);
        }
        catch (Exception ex) {
            Log.error("[MainForm]", ex);
        }
    }

    private void writePropertyFile() {
        try {
            Properties props = new Properties();
            MultimediaContainerManager.getContainerConfigs(props);
            props.setProperty(PROPERTY_SEARCHPATH, this.searchPath);
            props.setProperty(PROPERTY_EXPORTPATH, this.exportPath);
            props.setProperty(PROPERTY_LOOKANDFEEL, this.uiClassName);
            props.setProperty(PROPERTY_VOLUME_VALUE, Float.toString(this.currentVolume));
            props.setProperty(PROPERTY_BALANCE_VALUE, Float.toString(this.currentBalance));
            int i = 0;
            while (i < 10) {
                URL element = this.lastLoaded.get(i);
                if (element != null) {
                    props.setProperty("javamod.path.lastloaded." + i, element.toString());
                }
                ++i;
            }
            props.setProperty(PROPERTY_MAINDIALOG_POS, Helpers.getStringFromPoint(this.getLocation()));
            props.setProperty(PROPERTY_MAINDIALOG_SIZE, Helpers.getStringFromDimension(this.getSize()));
            props.setProperty(PROPERTY_SETUPDIALOG_POS, Helpers.getStringFromPoint(this.getPlayerSetUpDialog().getLocation()));
            props.setProperty(PROPERTY_SETUPDIALOG_SIZE, Helpers.getStringFromDimension(this.getPlayerSetUpDialog().getSize()));
            props.setProperty(PROPERTY_PROPERTIESDIALOG_POS, Helpers.getStringFromPoint(this.getModInfoDialog().getLocation()));
            props.setProperty(PROPERTY_PROPERTIESDIALOG_SIZE, Helpers.getStringFromDimension(this.getModInfoDialog().getSize()));
            File propertyFile = new File(String.valueOf(this.propertyFilePath) + File.separator + PROPERTYFILENAME);
            if (propertyFile.exists()) {
                propertyFile.delete();
                propertyFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(propertyFile);
            props.store(fos, WINDOW_TITLE);
        }
        catch (Exception ex) {
            Log.error("MainForm]", ex);
        }
    }

    private UIManager.LookAndFeelInfo[] getInstalledLookAndFeels() {
        return UIManager.getInstalledLookAndFeels();
    }

    private void createFileFilter() {
        HashMap<String, String[]> extensionMap = MultimediaContainerManager.getSupportedFileExtensionsPerContainer();
        ArrayList<FileChooserFilter> chooserFilterArray = new ArrayList<FileChooserFilter>(extensionMap.size() + 1);
        String[] containerExtensions = MultimediaContainerManager.getSupportedFileExtensions();
        String[] fullSupportedExtensions = new String[containerExtensions.length + 2];
        System.arraycopy(containerExtensions, 0, fullSupportedExtensions, 2, containerExtensions.length);
        fullSupportedExtensions[0] = "pls";
        fullSupportedExtensions[1] = "m3u";
        chooserFilterArray.add(new FileChooserFilter(fullSupportedExtensions, "All playable files"));
        Set<String> containerNameSet = extensionMap.keySet();
        for (String containerName : containerNameSet) {
            String[] extensions = extensionMap.get(containerName);
            StringBuilder fileText = new StringBuilder(containerName);
            fileText.append(" (");
            int ende = extensions.length - 1;
            int i = 0;
            while (i <= ende) {
                fileText.append("*.").append(extensions[i]);
                if (i < ende) {
                    fileText.append(", ");
                }
                ++i;
            }
            fileText.append(')');
            chooserFilterArray.add(new FileChooserFilter(extensions, fileText.toString()));
        }
        chooserFilterArray.add(new FileChooserFilter(new String[]{"pls", "m3u"}, "Playlist (*.pls, *.m3u)"));
        fileFilterLoad = new FileFilter[chooserFilterArray.size()];
        chooserFilterArray.toArray(fileFilterLoad);
        fileFilterExport = new FileFilter[1];
        MainForm.fileFilterExport[0] = new FileChooserFilter(AudioFileFormat.Type.WAVE.getExtension(), AudioFileFormat.Type.WAVE.toString());
    }

    private void initialize() {
        Log.addLogListener(this);
        this.readPropertyFile();
        this.updateLookAndFeel(this.uiClassName);
        this.setName(WINDOW_NAME);
        this.setTitle(WINDOW_TITLE);
        URL iconURL = MainForm.class.getResource(DEFAULTICONPATH);
        if (iconURL != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainForm.this.doClose();
            }
        });
        if (this.mainDialogSize == null || this.mainDialogSize.getWidth() == -1.0 || this.mainDialogSize.getHeight() == -1.0) {
            Insets insets = this.getInsets();
            this.mainDialogSize = new Dimension(300 + insets.left + insets.right, 350 + insets.top + insets.bottom);
        }
        this.setSize(this.mainDialogSize);
        this.setPreferredSize(this.mainDialogSize);
        this.setJMenuBar(this.getBaseMenuBar());
        this.setContentPane(this.getBaseContentPane());
        this.setPlayListIcons();
        this.pack();
        if (this.mainDialogLocation == null || this.mainDialogLocation.getX() == -1.0 || this.mainDialogLocation.getY() == -1.0) {
            this.mainDialogLocation = Helpers.getFrameCenteredLocation(this, null);
        }
        this.setLocation(this.mainDialogLocation);
        this.dropTargetList = new ArrayList();
        DropListener myListener = new DropListener();
        MainForm.registerDropListener(this.dropTargetList, this, myListener);
        this.audioProcessor = new AudioProcessor(2048, 70);
        this.audioProcessor.addListener(this);
        MultimediaContainerManager.addMultimediaContainerEventListener(this);
        this.createFileFilter();
        this.currentContainer = null;
        this.showMessage("Ready...");
    }

    private static void registerDropListener(ArrayList<DropTarget> list, Container basePanel, DropListener myListener) {
        list.add(new DropTarget(basePanel, myListener));
        Component[] components = basePanel.getComponents();
        int i = 0;
        while (i < components.length) {
            Component component = components[i];
            if (component instanceof Container) {
                MainForm.registerDropListener(list, (Container)component, myListener);
            } else {
                list.add(new DropTarget(component, myListener));
            }
            ++i;
        }
    }

    private boolean setLookAndFeel(String lookAndFeelClassName) {
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Throwable e) {
            this.showMessage("The selected Look&Feel is not supported or not reachable through the classpath. Switching to system default...");
            try {
                lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lookAndFeelClassName);
            }
            catch (Throwable e1) {
                Log.error("[MainForm]", e1);
                return false;
            }
        }
        return true;
    }

    private boolean updateLookAndFeel(String lookAndFeelClassName) {
        this.setLookAndFeel(lookAndFeelClassName);
        MultimediaContainerManager.updateLookAndFeel();
        SwingUtilities.updateComponentTreeUI(this);
        this.pack();
        SwingUtilities.updateComponentTreeUI(this.getJavaModAbout());
        this.getJavaModAbout().pack();
        SwingUtilities.updateComponentTreeUI(this.getModInfoDialog());
        this.getModInfoDialog().pack();
        SwingUtilities.updateComponentTreeUI(this.getPlayerSetUpDialog());
        this.getPlayerSetUpDialog().pack();
        return true;
    }

    private void changeInfoPane() {
        this.getModInfoPane().removeAll();
        this.getModInfoPane().add((Component)this.getCurrentContainer().getInfoPanel(), "Center");
        this.getModInfoDialog().pack();
        this.getModInfoDialog().repaint();
    }

    private void changeConfigPane() {
        this.getPlayerSetUpPane().removeAll();
        this.getPlayerSetUpPane().add((Component)this.getCurrentContainer().getConfigPanel(), "Center");
        this.getPlayerSetUpDialog().pack();
        this.getPlayerSetUpDialog().repaint();
    }

    private void changeExportMenu() {
        this.getMenu_File_exportWave().setEnabled(this.getCurrentContainer().canExport());
    }

    public JMenuBar getBaseMenuBar() {
        if (this.baseMenuBar == null) {
            this.baseMenuBar = new JMenuBar();
            this.baseMenuBar.setName("baseMenuBar");
            this.baseMenuBar.add(this.getMenu_File());
            this.baseMenuBar.add(this.getMenu_View());
            this.baseMenuBar.add(this.getMenu_LookAndFeel());
            this.baseMenuBar.add(this.getMenu_Help());
        }
        return this.baseMenuBar;
    }

    public JMenu getMenu_File() {
        if (this.menu_File == null) {
            this.menu_File = new JMenu();
            this.menu_File.setName("menu_File");
            this.menu_File.setMnemonic('f');
            this.menu_File.setText("File");
            this.menu_File.setFont(Helpers.DIALOG_FONT);
            this.menu_File.add(this.getMenu_File_openMod());
            this.menu_File.add(this.getMenu_File_openURL());
            this.menu_File.add(this.getMenu_File_exportWave());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_RecentFiles());
            this.menu_File.add(new JSeparator());
            this.menu_File.add(this.getMenu_File_Close());
        }
        return this.menu_File;
    }

    public JMenu getMenu_View() {
        if (this.menu_View == null) {
            this.menu_View = new JMenu();
            this.menu_View.setName("menu_View");
            this.menu_View.setMnemonic('v');
            this.menu_View.setText("View");
            this.menu_View.setFont(Helpers.DIALOG_FONT);
            this.menu_View.add(this.getMenu_View_Info());
            this.menu_View.add(this.getMenu_View_Setup());
        }
        return this.menu_View;
    }

    public JMenu getMenu_LookAndFeel() {
        if (this.menu_LookAndFeel == null) {
            this.menu_LookAndFeel = new JMenu();
            this.menu_LookAndFeel.setName("menu_LookAndFeel");
            this.menu_LookAndFeel.setMnemonic('l');
            this.menu_LookAndFeel.setText("Look&Feel");
            this.menu_LookAndFeel.setFont(Helpers.DIALOG_FONT);
            String currentUIClassName = UIManager.getLookAndFeel().getClass().getName();
            UIManager.LookAndFeelInfo[] lookAndFeels = this.getInstalledLookAndFeels();
            this.menu_LookAndFeel_Items = new JCheckBoxMenuItem[lookAndFeels.length];
            int i = 0;
            while (i < lookAndFeels.length) {
                this.menu_LookAndFeel_Items[i] = new JCheckBoxMenuItem();
                this.menu_LookAndFeel_Items[i].setName("newMenuItem_" + i);
                this.menu_LookAndFeel_Items[i].setText(lookAndFeels[i].getName());
                this.menu_LookAndFeel_Items[i].setFont(Helpers.DIALOG_FONT);
                this.menu_LookAndFeel_Items[i].setToolTipText("Change to " + lookAndFeels[i].getName() + " look and feel");
                String uiClassName = lookAndFeels[i].getClassName();
                if (uiClassName.equals(currentUIClassName)) {
                    this.menu_LookAndFeel_Items[i].setSelected(true);
                }
                this.menu_LookAndFeel_Items[i].addActionListener(new LookAndFeelChanger(this.menu_LookAndFeel_Items[i], uiClassName));
                this.menu_LookAndFeel.add(this.menu_LookAndFeel_Items[i]);
                ++i;
            }
        }
        return this.menu_LookAndFeel;
    }

    private JMenu getMenu_Help() {
        if (this.menu_Help == null) {
            this.menu_Help = new JMenu();
            this.menu_Help.setName("menu_Help");
            this.menu_Help.setMnemonic('h');
            this.menu_Help.setText("Help");
            this.menu_Help.setFont(Helpers.DIALOG_FONT);
            this.menu_Help.add(this.getMenu_Help_CheckUpdate());
            this.menu_Help.add(this.getMenu_Help_ShowVersionHistory());
            this.menu_Help.add(new JSeparator());
            this.menu_Help.add(this.getMenu_Help_About());
        }
        return this.menu_Help;
    }

    private JMenuItem getMenu_File_openMod() {
        if (this.menu_File_openMod == null) {
            this.menu_File_openMod = new JMenuItem();
            this.menu_File_openMod.setName("menu_File_openMod");
            this.menu_File_openMod.setMnemonic('o');
            this.menu_File_openMod.setText("Open Sound File...");
            this.menu_File_openMod.setFont(Helpers.DIALOG_FONT);
            this.menu_File_openMod.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doOpenModFile();
                }
            });
        }
        return this.menu_File_openMod;
    }

    private JMenuItem getMenu_File_openURL() {
        if (this.menu_File_openURL == null) {
            this.menu_File_openURL = new JMenuItem();
            this.menu_File_openURL.setName("menu_File_openURL");
            this.menu_File_openURL.setMnemonic('u');
            this.menu_File_openURL.setText("Open an URL...");
            this.menu_File_openURL.setFont(Helpers.DIALOG_FONT);
            this.menu_File_openURL.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doOpenURL();
                }
            });
        }
        return this.menu_File_openURL;
    }

    private JMenuItem getMenu_File_exportWave() {
        if (this.menu_File_exportWave == null) {
            this.menu_File_exportWave = new JMenuItem();
            this.menu_File_exportWave.setName("menu_File_exportWave");
            this.menu_File_exportWave.setMnemonic('e');
            this.menu_File_exportWave.setText("Export to wave...");
            this.menu_File_exportWave.setFont(Helpers.DIALOG_FONT);
            this.menu_File_exportWave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doExportToWave();
                }
            });
        }
        return this.menu_File_exportWave;
    }

    private JMenu getMenu_File_RecentFiles() {
        if (this.menu_File_RecentFiles == null) {
            this.menu_File_RecentFiles = new JMenu();
            this.menu_File_RecentFiles.setName("menu_File_RecentFiles");
            this.menu_File_RecentFiles.setMnemonic('r');
            this.menu_File_RecentFiles.setText("Recent files");
            this.menu_File_RecentFiles.setFont(Helpers.DIALOG_FONT);
            this.createRecentFileMenuItems();
        }
        return this.menu_File_RecentFiles;
    }

    private void createRecentFileMenuItems() {
        JMenu recent = this.getMenu_File_RecentFiles();
        recent.removeAll();
        int i = 0;
        int index = 1;
        while (i < 10) {
            URL element = this.lastLoaded.get(i);
            if (element != null) {
                String displayName = null;
                if (element.getProtocol().equalsIgnoreCase("file")) {
                    try {
                        File f = new File(element.toURI());
                        displayName = f.getAbsolutePath();
                    }
                    catch (URISyntaxException f) {
                        // empty catch block
                    }
                }
                if (displayName == null) {
                    displayName = this.lastLoaded.get(i).toString();
                }
                JMenuItem lastLoadURL = new JMenuItem();
                lastLoadURL.setName("menu_File_RecentFiles_File" + i);
                lastLoadURL.setText(String.valueOf(index < 10 ? "  " : "") + index++ + " " + displayName);
                lastLoadURL.setFont(Helpers.DIALOG_FONT);
                lastLoadURL.setToolTipText(element.toString());
                lastLoadURL.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            URL url = new URL(((JMenuItem)e.getSource()).getToolTipText());
                            MainForm.this.loadMultimediaOrPlayListFile(url);
                        }
                        catch (Exception ex) {
                            Log.error("Load recent error", ex);
                        }
                    }
                });
                recent.add(lastLoadURL);
            }
            ++i;
        }
    }

    private JMenuItem getMenu_File_Close() {
        if (this.menu_File_Close == null) {
            this.menu_File_Close = new JMenuItem();
            this.menu_File_Close.setName("menu_File_Close");
            this.menu_File_Close.setMnemonic('c');
            this.menu_File_Close.setText("Close");
            this.menu_File_Close.setFont(Helpers.DIALOG_FONT);
            this.menu_File_Close.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doClose();
                }
            });
        }
        return this.menu_File_Close;
    }

    private JMenuItem getMenu_View_Info() {
        if (this.menu_View_Info == null) {
            this.menu_View_Info = new JMenuItem();
            this.menu_View_Info.setName("menu_View_Info");
            this.menu_View_Info.setMnemonic('p');
            this.menu_View_Info.setText("Properties...");
            this.menu_View_Info.setFont(Helpers.DIALOG_FONT);
            this.menu_View_Info.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getModInfoDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Info;
    }

    private JMenuItem getMenu_View_Setup() {
        if (this.menu_View_Setup == null) {
            this.menu_View_Setup = new JMenuItem();
            this.menu_View_Setup.setName("menu_View_Setup");
            this.menu_View_Setup.setMnemonic('s');
            this.menu_View_Setup.setText("Setup...");
            this.menu_View_Setup.setFont(Helpers.DIALOG_FONT);
            this.menu_View_Setup.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getPlayerSetUpDialog().setVisible(true);
                }
            });
        }
        return this.menu_View_Setup;
    }

    private JMenuItem getMenu_Help_CheckUpdate() {
        if (this.menu_Help_CheckUpdate == null) {
            this.menu_Help_CheckUpdate = new JMenuItem();
            this.menu_Help_CheckUpdate.setName("menu_Help_CheckUpdate");
            this.menu_Help_CheckUpdate.setMnemonic('c');
            this.menu_Help_CheckUpdate.setText("Check for update...");
            this.menu_Help_CheckUpdate.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_CheckUpdate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doCheckUpdate();
                }
            });
        }
        return this.menu_Help_CheckUpdate;
    }

    private JMenuItem getMenu_Help_ShowVersionHistory() {
        if (this.menu_Help_ShowVersionHistory == null) {
            this.menu_Help_ShowVersionHistory = new JMenuItem();
            this.menu_Help_ShowVersionHistory.setName("menu_Help_showVersionHistory");
            this.menu_Help_ShowVersionHistory.setMnemonic('s');
            this.menu_Help_ShowVersionHistory.setText("Show version history...");
            this.menu_Help_ShowVersionHistory.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_ShowVersionHistory.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.getShowVersion_Text().setVisible(true);
                }
            });
        }
        return this.menu_Help_ShowVersionHistory;
    }

    private JMenuItem getMenu_Help_About() {
        if (this.menu_Help_About == null) {
            this.menu_Help_About = new JMenuItem();
            this.menu_Help_About.setName("menu_Help_About");
            this.menu_Help_About.setMnemonic('a');
            this.menu_Help_About.setText("About...");
            this.menu_Help_About.setFont(Helpers.DIALOG_FONT);
            this.menu_Help_About.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doShowAbout();
                }
            });
        }
        return this.menu_Help_About;
    }

    public JPanel getBaseContentPane() {
        if (this.baseContentPane == null) {
            this.baseContentPane = new JPanel();
            this.baseContentPane.setName("baseContentPane");
            this.baseContentPane.setLayout(new BorderLayout());
            this.baseContentPane.add((Component)this.getMessages(), "South");
            this.baseContentPane.add((Component)this.getMainContentPane(), "Center");
        }
        return this.baseContentPane;
    }

    public JTextField getMessages() {
        if (this.messages == null) {
            this.messages = new JTextField();
            this.messages.setName("messages");
            this.messages.setEditable(false);
            this.messages.setFont(Helpers.DIALOG_FONT);
        }
        return this.messages;
    }

    public JPanel getMainContentPane() {
        if (this.mainContentPane == null) {
            this.mainContentPane = new JPanel();
            this.mainContentPane.setName("mainContentPane");
            this.mainContentPane.setLayout(new GridBagLayout());
            this.mainContentPane.add((Component)this.getMusicDataPane(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerDataPane(), Helpers.getGridBagConstraint(0, 1, 1, 0, 1, 10, 0.0, 1.0));
            this.mainContentPane.add((Component)this.getPlayerControlPane(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 0.0, 0.0));
        }
        return this.mainContentPane;
    }

    public JDialog getModInfoDialog() {
        if (this.modInfoDialog == null) {
            this.modInfoDialog = new JDialog(this, "File properties", false);
            this.modInfoDialog.setName("modInfoDialog");
            if (this.modInfoDialogSize == null || this.modInfoDialogSize.getWidth() == -1.0 || this.modInfoDialogSize.getHeight() == -1.0) {
                this.modInfoDialogSize = new Dimension(600, 500);
            }
            this.modInfoDialog.setSize(this.modInfoDialogSize);
            this.modInfoDialog.setPreferredSize(this.modInfoDialogSize);
            this.modInfoDialog.setContentPane(this.getModInfoPane());
            if (this.modInfoDialogLocation == null || this.modInfoDialogLocation.getX() == -1.0 || this.modInfoDialogLocation.getY() == -1.0) {
                this.modInfoDialogLocation = Helpers.getFrameCenteredLocation(this.modInfoDialog, null);
            }
            this.modInfoDialog.setLocation(this.modInfoDialogLocation);
        }
        return this.modInfoDialog;
    }

    public JPanel getModInfoPane() {
        if (this.modInfoPane == null) {
            this.modInfoPane = new JPanel();
            this.modInfoPane.setName("ModInfoPane");
            this.modInfoPane.setLayout(new BorderLayout());
            this.modInfoPane.setBorder(new TitledBorder(null, "Multimedia File Info", 4, 2, Helpers.DIALOG_FONT, null));
            this.changeInfoPane();
        }
        return this.modInfoPane;
    }

    public JDialog getPlayerSetUpDialog() {
        if (this.playerSetUpDialog == null) {
            this.playerSetUpDialog = new JDialog(this, "Configuration", false);
            this.playerSetUpDialog.setName("playerSetUpDialog");
            if (this.playerSetUpDialogSize == null || this.playerSetUpDialogSize.getWidth() == -1.0 || this.playerSetUpDialogSize.getHeight() == -1.0) {
                this.playerSetUpDialogSize = new Dimension(550, 150);
            }
            this.playerSetUpDialog.setSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setPreferredSize(this.playerSetUpDialogSize);
            this.playerSetUpDialog.setContentPane(this.getPlayerSetUpPane());
            if (this.playerSetUpDialogLocation == null || this.playerSetUpDialogLocation.getX() == -1.0 || this.playerSetUpDialogLocation.getY() == -1.0) {
                this.playerSetUpDialogLocation = Helpers.getFrameCenteredLocation(this.playerSetUpDialog, null);
            }
            this.playerSetUpDialog.setLocation(this.playerSetUpDialogLocation);
        }
        return this.playerSetUpDialog;
    }

    public JPanel getPlayerSetUpPane() {
        if (this.playerSetUpPane == null) {
            this.playerSetUpPane = new JPanel();
            this.playerSetUpPane.setName("playerSetUpPane");
            this.playerSetUpPane.setLayout(new BorderLayout());
            this.playerSetUpPane.setBorder(new TitledBorder(null, "Mixer Control", 4, 2, Helpers.DIALOG_FONT, null));
            this.changeConfigPane();
        }
        return this.playerSetUpPane;
    }

    public JPanel getPlayerDataPane() {
        if (this.playerDataPane == null) {
            this.playerDataPane = new JPanel();
            this.playerDataPane.setName("playerDataPane");
            this.playerDataPane.setLayout(new GridBagLayout());
            this.playerDataPane.setBorder(new TitledBorder(null, "Player Data", 4, 2, Helpers.DIALOG_FONT, null));
            this.playerDataPane.add((Component)this.getVULMeterPanel(), Helpers.getGridBagConstraint(0, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSALMeterPanel(), Helpers.getGridBagConstraint(1, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getSARMeterPanel(), Helpers.getGridBagConstraint(2, 0, 1, 1, 0, 10, 0.0, 0.0));
            this.playerDataPane.add((Component)this.getVURMeterPanel(), Helpers.getGridBagConstraint(3, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.playerDataPane;
    }

    public JDialog getDownloadDialog() {
        if (this.downloadDialog == null) {
            this.downloadDialog = new JDialog(this, "Download progress", false);
            this.downloadDialog.setName("downloadDialog");
            Dimension size = new Dimension(250, 55);
            this.downloadDialog.setSize(size);
            this.downloadDialog.setPreferredSize(size);
            this.downloadDialog.setContentPane(this.getDownloadPane());
            this.downloadDialog.setLocation(Helpers.getFrameCenteredLocation(this.downloadDialog, this));
            this.downloadDialog.pack();
        }
        return this.downloadDialog;
    }

    public JPanel getDownloadPane() {
        if (this.downloadPane == null) {
            this.downloadPane = new JPanel();
            this.downloadPane.setName("downloadPane");
            this.downloadPane.setLayout(new GridBagLayout());
            this.downloadPane.add((Component)this.getDownloadProgressBar(), Helpers.getGridBagConstraint(0, 0, 1, 0, 1, 10, 1.0, 1.0));
        }
        return this.downloadPane;
    }

    public JProgressBar getDownloadProgressBar() {
        if (this.downloadProgressBar == null) {
            this.downloadProgressBar = new JProgressBar();
            this.downloadProgressBar.setMinimum(0);
            this.downloadProgressBar.setMaximum(100);
            this.downloadProgressBar.setValue(0);
        }
        return this.downloadProgressBar;
    }

    public SAMeterPanel getSALMeterPanel() {
        if (this.saLMeterPanel == null) {
            this.saLMeterPanel = new SAMeterPanel(20, 50, 0x7FFFFF);
            Dimension d = new Dimension(104, 60);
            this.saLMeterPanel.setSize(d);
            this.saLMeterPanel.setMaximumSize(d);
            this.saLMeterPanel.setMinimumSize(d);
            this.saLMeterPanel.setPreferredSize(d);
            this.saLMeterPanel.setDoubleBuffered(true);
            this.saLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saLMeterPanel;
    }

    public SAMeterPanel getSARMeterPanel() {
        if (this.saRMeterPanel == null) {
            this.saRMeterPanel = new SAMeterPanel(20, 50, 0x7FFFFF);
            Dimension d = new Dimension(104, 60);
            this.saRMeterPanel.setSize(d);
            this.saRMeterPanel.setMaximumSize(d);
            this.saRMeterPanel.setMinimumSize(d);
            this.saRMeterPanel.setPreferredSize(d);
            this.saRMeterPanel.setDoubleBuffered(true);
            this.saRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.saRMeterPanel;
    }

    public VUMeterPanel getVULMeterPanel() {
        if (this.vuLMeterPanel == null) {
            this.vuLMeterPanel = new VUMeterPanel(50, 0x7FFFFF);
            Dimension d = new Dimension(20, 100);
            this.vuLMeterPanel.setSize(d);
            this.vuLMeterPanel.setMaximumSize(d);
            this.vuLMeterPanel.setMinimumSize(d);
            this.vuLMeterPanel.setPreferredSize(d);
            this.vuLMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuLMeterPanel;
    }

    public VUMeterPanel getVURMeterPanel() {
        if (this.vuRMeterPanel == null) {
            this.vuRMeterPanel = new VUMeterPanel(50, 0x7FFFFF);
            Dimension d = new Dimension(20, 100);
            this.vuRMeterPanel.setSize(d);
            this.vuRMeterPanel.setMaximumSize(d);
            this.vuRMeterPanel.setMinimumSize(d);
            this.vuRMeterPanel.setPreferredSize(d);
            this.vuRMeterPanel.setBorder(new BevelBorder(1));
        }
        return this.vuRMeterPanel;
    }

    public JPanel getMusicDataPane() {
        if (this.musicDataPane == null) {
            this.musicDataPane = new JPanel();
            this.musicDataPane.setName("musicDataPane");
            this.musicDataPane.setLayout(new GridBagLayout());
            this.musicDataPane.setBorder(new TitledBorder(null, "Name", 4, 2, Helpers.DIALOG_FONT, null));
            this.musicDataPane.add((Component)this.getLEDScrollPanel(), Helpers.getGridBagConstraint(0, 0, 1, 0, 0, 10, 0.0, 0.0));
        }
        return this.musicDataPane;
    }

    public LEDScrollPanel getLEDScrollPanel() {
        int chars = 15;
        int brick = 3;
        if (this.ledScrollPanel == null) {
            this.ledScrollPanel = new LEDScrollPanel(30, "Java Mod Player V1.9.3.4 \u00a9 by Daniel Becker 2006/07/08/09/10                  ", chars, Color.GREEN, Color.GRAY);
            Dimension d = new Dimension(chars * brick * 6 + 4, brick * 8 + 4);
            this.ledScrollPanel.setSize(d);
            this.ledScrollPanel.setMaximumSize(d);
            this.ledScrollPanel.setMinimumSize(d);
            this.ledScrollPanel.setPreferredSize(d);
            this.ledScrollPanel.setBorder(new BevelBorder(1));
        }
        return this.ledScrollPanel;
    }

    public JPanel getPlayerControlPane() {
        if (this.playerControlPane == null) {
            this.playerControlPane = new JPanel();
            this.playerControlPane.setName("playerControlPane");
            this.playerControlPane.setLayout(new GridBagLayout());
            this.playerControlPane.setBorder(new TitledBorder(null, "Player Control", 4, 2, Helpers.DIALOG_FONT, null));
            this.playerControlPane.add((Component)this.getButton_Prev(), Helpers.getGridBagConstraint(0, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Play(), Helpers.getGridBagConstraint(1, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Next(), Helpers.getGridBagConstraint(2, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Pause(), Helpers.getGridBagConstraint(3, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getButton_Stop(), Helpers.getGridBagConstraint(4, 0, 2, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getVolumeSlider(), Helpers.getGridBagConstraint(5, 0, 1, 1, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getBalanceSlider(), Helpers.getGridBagConstraint(6, 0, 1, 0, 3, 10, 0.0, 1.0));
            this.playerControlPane.add((Component)this.getVolumeLabel(), Helpers.getGridBagConstraint(5, 1, 1, 1, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getBalanceLabel(), Helpers.getGridBagConstraint(6, 1, 1, 0, 0, 10, 0.0, 0.0));
            this.playerControlPane.add((Component)this.getSeekBarPanel(), Helpers.getGridBagConstraint(0, 2, 1, 0, 1, 10, 1.0, 1.0));
        }
        return this.playerControlPane;
    }

    private SeekBarPanel getSeekBarPanel() {
        if (this.seekBarPanel == null) {
            this.seekBarPanel = new SeekBarPanel(30);
            this.seekBarPanel.setName("SeekBarPanel");
        }
        return this.seekBarPanel;
    }

    private JButton getButton_Play() {
        if (this.button_Play == null) {
            this.buttonPlay_normal = new ImageIcon(this.getClass().getResource(BUTTONPLAY_NORMAL));
            this.buttonPlay_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPLAY_INACTIVE));
            this.buttonPlay_Active = new ImageIcon(this.getClass().getResource(BUTTONPLAY_ACTIVE));
            this.button_Play = new JButton();
            this.button_Play.setName("button_Play");
            this.button_Play.setText("");
            this.button_Play.setToolTipText("play");
            this.button_Play.setHorizontalTextPosition(0);
            this.button_Play.setVerticalTextPosition(3);
            this.button_Play.setIcon(this.buttonPlay_normal);
            this.button_Play.setDisabledIcon(this.buttonPlay_Inactive);
            this.button_Play.setPressedIcon(this.buttonPlay_Active);
            this.button_Play.setMargin(new Insets(4, 6, 4, 6));
            this.button_Play.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStartPlaying();
                }
            });
        }
        return this.button_Play;
    }

    private JButton getButton_Pause() {
        if (this.button_Pause == null) {
            this.buttonPause_normal = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_NORMAL));
            this.buttonPause_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_INACTIVE));
            this.buttonPause_Active = new ImageIcon(this.getClass().getResource(BUTTONPAUSE_ACTIVE));
            this.button_Pause = new JButton();
            this.button_Pause.setName("button_Pause");
            this.button_Pause.setText("");
            this.button_Pause.setToolTipText("pause");
            this.button_Pause.setHorizontalTextPosition(0);
            this.button_Pause.setVerticalTextPosition(3);
            this.button_Pause.setIcon(this.buttonPause_normal);
            this.button_Pause.setDisabledIcon(this.buttonPause_Inactive);
            this.button_Pause.setPressedIcon(this.buttonPause_Active);
            this.button_Pause.setMargin(new Insets(4, 6, 4, 6));
            this.button_Pause.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPausePlaying();
                }
            });
        }
        return this.button_Pause;
    }

    private JButton getButton_Stop() {
        if (this.button_Stop == null) {
            this.buttonStop_normal = new ImageIcon(this.getClass().getResource(BUTTONSTOP_NORMAL));
            this.buttonStop_Inactive = new ImageIcon(this.getClass().getResource(BUTTONSTOP_INACTIVE));
            this.buttonStop_Active = new ImageIcon(this.getClass().getResource(BUTTONSTOP_ACTIVE));
            this.button_Stop = new JButton();
            this.button_Stop.setName("button_Stop");
            this.button_Stop.setText("");
            this.button_Stop.setToolTipText("stop");
            this.button_Stop.setHorizontalTextPosition(0);
            this.button_Stop.setVerticalTextPosition(3);
            this.button_Stop.setIcon(this.buttonStop_normal);
            this.button_Stop.setDisabledIcon(this.buttonStop_Inactive);
            this.button_Stop.setPressedIcon(this.buttonStop_Active);
            this.button_Stop.setMargin(new Insets(4, 6, 4, 6));
            this.button_Stop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doStopPlaying();
                }
            });
        }
        return this.button_Stop;
    }

    private JButton getButton_Prev() {
        if (this.button_Prev == null) {
            this.buttonPrev_normal = new ImageIcon(this.getClass().getResource(BUTTONPREV_NORMAL));
            this.buttonPrev_Inactive = new ImageIcon(this.getClass().getResource(BUTTONPREV_INACTIVE));
            this.buttonPrev_Active = new ImageIcon(this.getClass().getResource(BUTTONPREV_ACTIVE));
            this.button_Prev = new JButton();
            this.button_Prev.setName("button_Prev");
            this.button_Prev.setText("");
            this.button_Prev.setToolTipText("previous");
            this.button_Prev.setHorizontalTextPosition(0);
            this.button_Prev.setVerticalTextPosition(3);
            this.button_Prev.setIcon(this.buttonPrev_normal);
            this.button_Prev.setDisabledIcon(this.buttonPrev_Inactive);
            this.button_Prev.setPressedIcon(this.buttonPrev_Active);
            this.button_Prev.setMargin(new Insets(4, 6, 4, 6));
            this.button_Prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doPrevPlayListEntry();
                }
            });
        }
        return this.button_Prev;
    }

    private JButton getButton_Next() {
        if (this.button_Next == null) {
            this.buttonNext_normal = new ImageIcon(this.getClass().getResource(BUTTONNEXT_NORMAL));
            this.buttonNext_Inactive = new ImageIcon(this.getClass().getResource(BUTTONNEXT_INACTIVE));
            this.buttonNext_Active = new ImageIcon(this.getClass().getResource(BUTTONNEXT_ACTIVE));
            this.button_Next = new JButton();
            this.button_Next.setName("button_Next");
            this.button_Next.setText("");
            this.button_Next.setToolTipText("next");
            this.button_Next.setHorizontalTextPosition(0);
            this.button_Next.setVerticalTextPosition(3);
            this.button_Next.setIcon(this.buttonNext_normal);
            this.button_Next.setDisabledIcon(this.buttonNext_Inactive);
            this.button_Next.setPressedIcon(this.buttonNext_Active);
            this.button_Next.setMargin(new Insets(4, 6, 4, 6));
            this.button_Next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainForm.this.doNextPlayListEntry();
                }
            });
        }
        return this.button_Next;
    }

    public JLabel getVolumeLabel() {
        if (this.volumeLabel == null) {
            this.volumeLabel = new JLabel("Volume");
            this.volumeLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.volumeLabel;
    }

    public RoundSlider getVolumeSlider() {
        if (this.volumeSlider == null) {
            this.volumeSlider = new RoundSlider();
            this.volumeSlider.setSize(new Dimension(20, 20));
            this.volumeSlider.setMinimumSize(new Dimension(20, 20));
            this.volumeSlider.setMaximumSize(new Dimension(20, 20));
            this.volumeSlider.setPreferredSize(new Dimension(20, 20));
            this.volumeSlider.setValue(this.currentVolume);
            this.volumeSlider.setToolTipText(String.valueOf(Float.toString(this.currentVolume * 100.0f)) + '%');
            this.volumeSlider.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    if (e.getClickCount() == 2) {
                        slider.setValue(0.5f);
                    }
                }
            });
            this.volumeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    MainForm.this.currentVolume = slider.getValue();
                    if (MainForm.this.currentVolume < 0.0f) {
                        MainForm.this.currentVolume = 0.0f;
                    } else if (MainForm.this.currentVolume > 1.0f) {
                        MainForm.this.currentVolume = 1.0f;
                    }
                    slider.setToolTipText(String.valueOf(Float.toString(MainForm.this.currentVolume * 100.0f)) + '%');
                    MainForm.this.doSetVoumeValue();
                }
            });
        }
        return this.volumeSlider;
    }

    public JLabel getBalanceLabel() {
        if (this.balanceLabel == null) {
            this.balanceLabel = new JLabel("Balance");
            this.balanceLabel.setFont(Helpers.DIALOG_FONT);
        }
        return this.balanceLabel;
    }

    public RoundSlider getBalanceSlider() {
        if (this.balanceSlider == null) {
            this.balanceSlider = new RoundSlider();
            this.balanceSlider.setSize(new Dimension(20, 20));
            this.balanceSlider.setMinimumSize(new Dimension(20, 20));
            this.balanceSlider.setMaximumSize(new Dimension(20, 20));
            this.balanceSlider.setPreferredSize(new Dimension(20, 20));
            this.balanceSlider.setValue((this.currentBalance + 1.0f) / 2.0f);
            this.balanceSlider.setToolTipText(String.valueOf(Float.toString(this.currentBalance * 100.0f)) + '%');
            this.balanceSlider.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    if (e.getClickCount() == 2) {
                        slider.setValue(0.5f);
                    }
                }
            });
            this.balanceSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    RoundSlider slider = (RoundSlider)e.getSource();
                    MainForm.this.currentBalance = slider.getValue() * 2.0f - 1.0f;
                    slider.setToolTipText(String.valueOf(Float.toString(MainForm.this.currentBalance * 100.0f)) + '%');
                    MainForm.this.doSetBalanceValue();
                }
            });
        }
        return this.balanceSlider;
    }

    private JavaModAbout getJavaModAbout() {
        if (this.about == null) {
            this.about = new JavaModAbout((Frame)this, true);
        } else {
            this.about.setLocation(Helpers.getFrameCenteredLocation(this.about, this));
        }
        return this.about;
    }

    private UrlDialog getURLDialog() {
        if (this.urlDialog == null) {
            this.urlDialog = new UrlDialog(this, true, "");
        } else {
            this.urlDialog.setLocation(Helpers.getFrameCenteredLocation(this.urlDialog, this));
        }
        return this.urlDialog;
    }

    @Override
    public void currentSampleChanged(int[] leftSample, int[] rightSample) {
        this.getVULMeterPanel().setVUMeter(leftSample);
        this.getVURMeterPanel().setVUMeter(rightSample);
        this.getSALMeterPanel().setMeter(leftSample);
        this.getSARMeterPanel().setMeter(rightSample);
    }

    @Override
    public void playThreadEventOccured(PlayThread thread) {
        if (thread.isRunning()) {
            this.getButton_Play().setIcon(this.buttonPlay_Active);
        } else {
            this.getButton_Play().setIcon(this.buttonPlay_normal);
            this.getSALMeterPanel().setMeter(null);
            this.getSARMeterPanel().setMeter(null);
            if (thread.getHasFinishedNormaly()) {
                this.doNextPlayListEntry();
            }
        }
        Mixer mixer = thread.getCurrentMixer();
        if (mixer != null) {
            if (mixer.isPaused()) {
                this.getButton_Pause().setIcon(this.buttonPause_Active);
            } else {
                this.getButton_Pause().setIcon(this.buttonPause_normal);
            }
        }
    }

    @Override
    public void multimediaContainerEventOccured(MultimediaContainerEvent event) {
        if (event.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED) {
            this.getLEDScrollPanel().addScrollText(String.valueOf(event.getEvent().toString()) + "     ");
        } else if (event.getType() == MultimediaContainerEvent.SONG_NAME_CHANGED_OLD_INVALID) {
            this.getLEDScrollPanel().setScrollTextTo(String.valueOf(event.getEvent().toString()) + "     ");
        }
    }

    private void setPlayListIcons() {
        if (this.currentPlayList == null) {
            this.getButton_Prev().setEnabled(false);
            this.getButton_Next().setEnabled(false);
        } else {
            this.getButton_Prev().setEnabled(this.currentPlayList.hasPrevious());
            this.getButton_Next().setEnabled(this.currentPlayList.hasNext());
        }
    }

    public void doClose() {
        this.doStopPlaying();
        this.writePropertyFile();
        if (this.audioProcessor != null) {
            this.audioProcessor.removeListener(this);
        }
        MultimediaContainerManager.removeMultimediaContainerEventListener(this);
        Log.removeLogListener(this);
        this.getModInfoDialog().setVisible(false);
        this.getPlayerSetUpDialog().setVisible(false);
        this.setVisible(false);
        this.getModInfoDialog().dispose();
        this.getPlayerSetUpDialog().dispose();
        this.dispose();
        System.exit(0);
    }

    public void doOpenModFile() {
        FileChooserResult selectedFile = Helpers.selectFileNameFor(this, this.searchPath, "Load a Sound-File", fileFilterLoad, 0);
        if (selectedFile != null) {
            this.doOpenFile(selectedFile.getSelectedFile());
        }
    }

    public void doOpenURL() {
        this.getURLDialog().setVisible(true);
        String url = this.getURLDialog().getURL();
        if (url != null && url.length() != 0) {
            this.doOpenURL(url);
        }
    }

    public void doOpenFile(File f) {
        if (f != null) {
            if (f.isFile()) {
                String modFileName = f.getAbsolutePath();
                int i = modFileName.lastIndexOf(File.separatorChar);
                this.searchPath = modFileName.substring(0, i);
                try {
                    this.loadMultimediaOrPlayListFile(f.toURI().toURL());
                }
                catch (MalformedURLException ex) {
                    Log.error("MainForm::doOpenFile", ex);
                }
            } else if (f.isDirectory()) {
                this.searchPath = f.getAbsolutePath();
            }
        }
    }

    public void doOpenURL(String surl) {
        if (surl != null) {
            try {
                URL url = new URL(surl);
                this.loadMultimediaOrPlayListFile(url);
            }
            catch (MalformedURLException ex) {
                Log.error("MainForm::doOpenFile", ex);
            }
        }
    }

    public void doExportToWave() {
        this.doStopPlaying();
        if (this.currentContainer != null) {
            block2: {
                File f;
                block3: {
                    int result;
                    do {
                        String fileName = this.currentContainer.getFileURL().getPath();
                        fileName = fileName.substring(fileName.lastIndexOf(47));
                        String exportToWav = String.valueOf(this.exportPath) + File.separator + fileName + ".WAV";
                        FileChooserResult selectedFile = Helpers.selectFileNameFor(this, exportToWav, "Export to wave", fileFilterExport, 1);
                        if (selectedFile == null || (f = selectedFile.getSelectedFile()) == null) break block2;
                        if (!f.exists()) break block3;
                        result = JOptionPane.showConfirmDialog(this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                        if (result != 2) continue;
                        return;
                    } while (result == 1);
                    f.delete();
                }
                String modFileName = f.getAbsolutePath();
                int i = modFileName.lastIndexOf(File.separatorChar);
                this.exportPath = modFileName.substring(0, i);
                Mixer mixer = this.createNewMixer();
                int result = JOptionPane.showConfirmDialog(this, "Continue playback while exporting?", "Playback?", 0, 3);
                mixer.setPlayDuringExport(result == 0);
                this.playerThread = new PlayThread(mixer, f, this);
                this.playerThread.start();
            }
            return;
        }
        JOptionPane.showMessageDialog(this, "You need to load a file first!", "Ups!", 0);
    }

    private SimpleTextViewerDialog getShowVersion_Text() {
        if (this.simpleTextViewerDialog == null) {
            try {
                this.simpleTextViewerDialog = new SimpleTextViewerDialog((JFrame)this, true, "http://www.quippy.de/download.php?file=./modplayer/javamod_version.txt");
            }
            catch (MalformedURLException ex) {
                Log.error("doCheckUpdate", ex);
            }
        }
        return this.simpleTextViewerDialog;
    }

    public void doCheckUpdate() {
        new Thread(new Runnable(){

            public void run() {
                String serverVersion = Helpers.getCurrentServerVersion();
                int compareResult = Helpers.compareVersions("V1.9.3.4", serverVersion);
                if (compareResult < 0) {
                    int result;
                    File f = new File(".");
                    String programmDestination = f.getAbsolutePath();
                    int resultHistory = JOptionPane.showConfirmDialog(MainForm.this, "There is a new version available!\n\nYour version: V1.9.3.4 - online verison: " + serverVersion + "\n\nWatch version history?\n\n", "New Version", 0, 3);
                    if (resultHistory == 0) {
                        MainForm.this.getShowVersion_Text().setVisible(true);
                    }
                    if ((result = JOptionPane.showConfirmDialog(MainForm.this, "Your version: V1.9.3.4 - online verison: " + serverVersion + "\n\nShould I start the download?\n\n", "New Version", 0, 3)) == 0) {
                        File destination;
                        block11: {
                            JFileChooser chooser = new JFileChooser();
                            chooser.setDialogTitle("Select download destination");
                            chooser.setFileSelectionMode(1);
                            chooser.setAcceptAllFileFilterUsed(false);
                            chooser.setApproveButtonText("Save here");
                            while (true) {
                                if (chooser.showOpenDialog(MainForm.this) != 0) {
                                    continue;
                                }
                                File destinationDir = chooser.getSelectedFile();
                                destination = new File(String.valueOf(destinationDir.getAbsolutePath()) + File.separatorChar + "javamod.jar");
                                if (!destination.exists()) break block11;
                                int owresult = JOptionPane.showConfirmDialog(MainForm.this, "File already exists! Overwrite?", "Overwrite confirmation", 1, 3);
                                if (owresult == 2) {
                                    return;
                                }
                                if (owresult != 1) break;
                            }
                            destination.delete();
                        }
                        JProgressBar bar = MainForm.this.getDownloadProgressBar();
                        bar.setValue(0);
                        MainForm.this.getDownloadDialog().setVisible(true);
                        int copied = Helpers.downloadJavaMod(destination, bar);
                        MainForm.this.getDownloadDialog().setVisible(false);
                        if (copied == -1) {
                            JOptionPane.showMessageDialog(MainForm.this, "Download failed!\n" + destination, "Failed", 0);
                        } else {
                            JOptionPane.showMessageDialog(MainForm.this, "Saved " + copied + " bytes successfully to\n" + destination + "\n\nNow exit JavaMod, move the downloaded file to\n" + programmDestination + "\nand restart javamod.\n\n", "Success", 1);
                        }
                        return;
                    }
                } else if (compareResult > 0) {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is newer!", "Newer version", 1);
                } else {
                    JOptionPane.showMessageDialog(MainForm.this, "Your version of JavaMod is up-to-date.", "Up-To-Date", 1);
                }
            }
        }).start();
    }

    public void doShowAbout() {
        this.getJavaModAbout().setVisible(true);
    }

    private void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            Mixer mixer = this.createNewMixer();
            if (mixer != null) {
                this.playerThread = new PlayThread(mixer, null, this);
                this.playerThread.start();
            }
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
            this.removeMixer();
        }
    }

    private void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }

    private void doNextPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !ok) {
            this.currentPlayList.next();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
    }

    private void doPrevPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !ok) {
            this.currentPlayList.previous();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
    }

    private void doSetVoumeValue() {
        if (this.playerThread != null) {
            Mixer currentMixer = this.playerThread.getCurrentMixer();
            currentMixer.setVolume(this.currentVolume);
        }
    }

    private void doSetBalanceValue() {
        if (this.playerThread != null) {
            Mixer currentMixer = this.playerThread.getCurrentMixer();
            currentMixer.setBalance(this.currentBalance);
        }
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.getCurrentContainer().createNewMixer();
        if (mixer != null) {
            mixer.setAudioProcessor(this.audioProcessor);
            mixer.setVolume(this.currentVolume);
            this.getSeekBarPanel().setCurrentMixer(mixer);
        }
        return mixer;
    }

    private void removeMixer() {
        this.getSeekBarPanel().setCurrentMixer(null);
    }

    private void loadMultimediaOrPlayListFile(URL mediaPLSFileURL) {
        Log.info("");
        this.addFileToLastLoaded(mediaPLSFileURL);
        this.currentPlayList = null;
        try {
            String checkPLS = mediaPLSFileURL.toURI().getPath().toLowerCase();
            if (checkPLS.endsWith(".pls") || checkPLS.endsWith(".m3u")) {
                this.currentPlayList = PlayList.createFromFile(mediaPLSFileURL, false);
                this.doNextPlayListEntry();
            } else {
                this.loadMultimediaFile(mediaPLSFileURL);
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
        }
    }

    private boolean loadMultimediaFile(URL mediaFileURL) {
        try {
            if (mediaFileURL != null) {
                this.currentContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL);
                this.getLEDScrollPanel().setScrollTextTo(String.valueOf(this.currentContainer.getSongName()) + "     ");
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaFile]", ex);
            return false;
        }
        this.changeInfoPane();
        this.changeConfigPane();
        this.changeExportMenu();
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying();
        }
        return true;
    }

    private void addFileToLastLoaded(URL url) {
        if (this.lastLoaded.contains(url)) {
            this.lastLoaded.remove(url);
        }
        this.lastLoaded.add(0, url);
        this.createRecentFileMenuItems();
    }

    private MultimediaContainer getCurrentContainer() {
        if (this.currentContainer == null) {
            try {
                this.currentContainer = MultimediaContainerManager.getMultimediaContainerForType("mod");
            }
            catch (Exception ex) {
                Log.error("getCurrentContainer()", ex);
            }
        }
        return this.currentContainer;
    }

    private synchronized void showMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainForm.this.getMessages().setText(msg);
            }
        });
    }

    @Override
    public void error(String message, Throwable ex) {
        if (ex != null) {
            this.showMessage(String.valueOf(message) + '|' + ex.toString());
            ex.printStackTrace(System.err);
        } else {
            this.showMessage(message);
        }
    }

    @Override
    public void info(String message) {
        this.showMessage(message);
    }

    private final class DropListener
    extends DropTargetAdapter {
        private DropListener() {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable t = dtde.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dtde.acceptDrop(3);
                    Object userObject = t.getTransferData(DataFlavor.javaFileListFlavor);
                    if (userObject instanceof List) {
                        MainForm.this.doStopPlaying();
                        String fileName = ((List)userObject).get(0).toString();
                        File f = new File(fileName);
                        MainForm.this.loadMultimediaOrPlayListFile(f.toURI().toURL());
                        if (MainForm.this.playerThread == null) {
                            MainForm.this.doStartPlaying();
                        }
                    }
                    dtde.dropComplete(true);
                }
            }
            catch (Exception ex) {
                Log.error("[MainForm::DropListener]", ex);
            }
        }
    }

    private final class LookAndFeelChanger
    implements ActionListener {
        private String uiClassName;
        private JCheckBoxMenuItem parent;

        public LookAndFeelChanger(JCheckBoxMenuItem parent, String uiClassName) {
            this.uiClassName = uiClassName;
            this.parent = parent;
        }

        private void setSelection() {
            int i = 0;
            while (i < MainForm.this.menu_LookAndFeel_Items.length) {
                if (MainForm.this.menu_LookAndFeel_Items[i] == this.parent) {
                    MainForm.this.menu_LookAndFeel_Items[i].setSelected(true);
                } else {
                    MainForm.this.menu_LookAndFeel_Items[i].setSelected(false);
                }
                ++i;
            }
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelection();
            MainForm.this.uiClassName = this.uiClassName;
            MainForm.this.updateLookAndFeel(this.uiClassName);
        }
    }
}

