/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main.applet;

import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.system.Helpers;
import de.quippy.javamod.system.Log;
import java.applet.Applet;
import java.awt.HeadlessException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public abstract class JavaModAppletBase
extends Applet
implements PlayThreadEventListener {
    private static final long serialVersionUID = 7586730327373678282L;
    private URL modFileName = null;
    private URL guiFileName;
    private boolean shuffle;
    private boolean autostart;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread = null;
    private PlayList currentPlayList = null;

    static {
        try {
            Helpers.registerAllClasses();
        }
        catch (ClassNotFoundException ex) {
            Log.error("JavaModMainBase: a class moved?!", ex);
        }
    }

    public void init() {
        try {
            this.parseParameters();
            this.initGui();
            this.loadMultimediaOrPlayListFile(this.modFileName);
            if (this.autostart) {
                this.doStartPlaying();
            }
        }
        catch (Exception ex) {
            Log.error("Error occured:", ex);
        }
    }

    public abstract void playThreadEventOccured(PlayThread var1);

    protected abstract void setPlayListIcons();

    protected abstract void setNewSongName(String var1);

    protected abstract void initGui();

    protected PlayList getCurrentPlayList() {
        return this.currentPlayList;
    }

    public URL getModFileName() {
        return this.modFileName;
    }

    public URL getGuiFileName() {
        return this.guiFileName;
    }

    public MultimediaContainer getCurrentContainer() {
        return this.currentContainer;
    }

    private void parseParameters() {
        Properties props = new Properties();
        String value = this.getParameter("i");
        if (value != null) {
            props.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(value)));
        }
        if ((value = this.getParameter("s")) != null) {
            props.setProperty("javamod.player.stereo", value.charAt(0) == '+' ? "2" : "1");
        }
        if ((value = this.getParameter("w")) != null) {
            props.setProperty("javamod.player.widestereomix", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("n")) != null) {
            props.setProperty("javamod.player.noisereduction", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("l")) != null) {
            props.setProperty("javamod.player.noloops", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("m")) != null) {
            props.setProperty("javamod.player.megabass", value.charAt(0) == '+' ? "TRUE" : "FALSE");
        }
        if ((value = this.getParameter("h")) != null) {
            boolean bl = this.shuffle = value.charAt(0) == '+';
        }
        this.autostart = (value = this.getParameter("a")) != null ? value.charAt(0) == '+' : true;
        value = this.getParameter("b");
        if (value != null) {
            int sampleSizeInBits = Integer.parseInt(value);
            if (sampleSizeInBits != 8 && sampleSizeInBits != 16 && sampleSizeInBits != 24) {
                throw new RuntimeException("samplesize of " + sampleSizeInBits + " is not supported");
            }
            props.setProperty("javamod.player.bitspersample", Integer.toString(sampleSizeInBits));
        }
        if ((value = this.getParameter("r")) != null) {
            props.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(value)));
        }
        MultimediaContainerManager.configureContainer(props);
        value = this.getParameter("ui-properties");
        try {
            if (value != null) {
                this.guiFileName = new URL(value);
            }
        }
        catch (MalformedURLException ex) {
            Log.error("[Applet::parseParameters]", ex);
        }
        value = this.getParameter("file");
        try {
            if (value != null) {
                this.modFileName = new URL(value);
            }
        }
        catch (MalformedURLException ex) {
            Log.error("[Applet::parseParameters]", ex);
        }
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        return mixer;
    }

    private void loadMultimediaOrPlayListFile(URL mediaPLSFileURL) {
        this.currentPlayList = null;
        try {
            String checkPLS = mediaPLSFileURL.getPath().toLowerCase();
            if (checkPLS.endsWith(".pls") || checkPLS.endsWith(".m3u")) {
                this.currentPlayList = PlayList.createFromFile(mediaPLSFileURL, this.shuffle);
                this.doNextPlayListEntry();
            } else {
                this.loadMultimediaFile(mediaPLSFileURL);
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
        }
    }

    private boolean loadMultimediaFile(URL mediaFileURL) {
        try {
            if (mediaFileURL != null) {
                this.currentContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL);
                this.setNewSongName(this.currentContainer.getSongName());
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaFile]", ex);
            return false;
        }
        this.setPlayListIcons();
        if (this.playerThread != null) {
            this.doStartPlaying();
        }
        return true;
    }

    protected void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            this.playerThread = new PlayThread(this.createNewMixer(), null, this);
            this.playerThread.start();
        }
    }

    protected void doNextPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasNext() && !ok) {
            this.currentPlayList.next();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
    }

    protected void doPrevPlayListEntry() {
        boolean ok = false;
        while (this.currentPlayList != null && this.currentPlayList.hasPrevious() && !ok) {
            this.currentPlayList.previous();
            ok = this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
        }
    }

    protected void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
        }
    }

    protected void doPausePlaying() {
        if (this.playerThread != null) {
            this.playerThread.pausePlay();
        }
    }
}

