/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.main;

import de.quippy.javamod.main.JavaModMainBase;
import de.quippy.javamod.main.gui.PlayThread;
import de.quippy.javamod.main.gui.PlayThreadEventListener;
import de.quippy.javamod.main.playlist.PlayList;
import de.quippy.javamod.mixer.Mixer;
import de.quippy.javamod.multimedia.MultimediaContainer;
import de.quippy.javamod.multimedia.MultimediaContainerManager;
import de.quippy.javamod.multimedia.mod.ModContainer;
import de.quippy.javamod.system.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class CommandLine
extends JavaModMainBase
implements PlayThreadEventListener {
    private URL modFileName;
    private File wavFileName;
    private boolean shuffle;
    private MultimediaContainer currentContainer;
    private PlayThread playerThread = null;
    private PlayList currentPlayList = null;

    public CommandLine() {
        super(false);
    }

    private static void showHelp() {
        Log.info("java -jar ./javamod [-rx] [-b{8,16,24}] [-s{+,-}] [-i{+,-}] [-w{+,-}] [-n{+,-}] [-m{+,-}] [-l{+,-}] [-h{+,-}]");
        Log.info("                    [-eWAVFILE] MODFILE\n");
        Log.info("-rx        : use Samplerate x (8000/11025/22050/44100/96000...");
        Log.info("                               anything allowed, your soundhardware supports)");
        Log.info("-b8/16/24  : #Bits per sample");
        Log.info("-s+/-      : Stereo/Mono");
        Log.info("-i0/1/2/3  : interpolation: 0:none; 1:linear; 2:cubic spline; 3:fir interpolation");
        Log.info("-w+/-      : do/don't wide stereo mix");
        Log.info("-n+/-      : do/don't noise reduction");
        Log.info("-m+/-      : do/don't mega bass");
        Log.info("-l+/-      : do/don't fade out infinit loops");
        Log.info("-h+/-      : do/don't shuffle playlists after loading");
        Log.info("-eWAVEFILE : export to wave file");
    }

    private void parseParameters(String[] args) {
        Properties props = new Properties();
        int i = 0;
        while (i < args.length) {
            block19: {
                block18: {
                    if (!args[i].startsWith("-")) break block18;
                    String op = args[i].substring(2);
                    switch (args[i].toLowerCase().charAt(1)) {
                        case 'i': {
                            props.setProperty("javamod.player.ISP", Integer.toString(Integer.parseInt(op.substring(0, 1))));
                            break block19;
                        }
                        case 's': {
                            props.setProperty("javamod.player.stereo", op.charAt(0) == '+' ? "2" : "1");
                            break block19;
                        }
                        case 'w': {
                            props.setProperty("javamod.player.widestereomix", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block19;
                        }
                        case 'n': {
                            props.setProperty("javamod.player.noisereduction", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block19;
                        }
                        case 'm': {
                            props.setProperty("javamod.player.megabass", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block19;
                        }
                        case 'l': {
                            props.setProperty("javamod.player.noloops", op.charAt(0) == '+' ? "TRUE" : "FALSE");
                            break block19;
                        }
                        case 'h': {
                            this.shuffle = op.charAt(0) == '+';
                            break block19;
                        }
                        case 'b': {
                            int sampleSizeInBits = Integer.parseInt(op);
                            if (sampleSizeInBits != 8 && sampleSizeInBits != 16 && sampleSizeInBits != 24) {
                                throw new RuntimeException("samplesize of " + sampleSizeInBits + " is not supported");
                            }
                            props.setProperty("javamod.player.bitspersample", Integer.toString(sampleSizeInBits));
                            break block19;
                        }
                        case 'r': {
                            props.setProperty("javamod.player.frequency", Integer.toString(Integer.parseInt(op)));
                            break block19;
                        }
                        case 'e': {
                            this.wavFileName = new File(op);
                            break block19;
                        }
                        default: {
                            throw new RuntimeException("Unknown parameter: " + args[i].charAt(1));
                        }
                    }
                }
                String fileName = args[i];
                try {
                    this.modFileName = new URL(fileName);
                }
                catch (MalformedURLException ex) {
                    try {
                        this.modFileName = new File(fileName).toURI().toURL();
                    }
                    catch (MalformedURLException exe) {
                        Log.error("This is not parsable: " + fileName, ex);
                        System.exit(-1);
                    }
                }
            }
            ++i;
        }
        MultimediaContainerManager.configureContainer(props);
    }

    public void playThreadEventOccured(PlayThread thread) {
        if (!thread.isRunning() && thread.getHasFinishedNormaly()) {
            if (this.currentPlayList != null && this.currentPlayList.next()) {
                this.loadMultimediaFile(this.currentPlayList.getCurrentEntry().getFile());
            } else {
                System.exit(0);
            }
        }
    }

    private void doStartPlaying() {
        if (this.currentContainer != null) {
            this.doStopPlaying();
            if (this.currentContainer instanceof ModContainer) {
                System.out.println(((ModContainer)this.currentContainer).getCurrentMod().toString());
            }
            this.playerThread = new PlayThread(this.createNewMixer(), this.wavFileName, this);
            this.playerThread.start();
        }
    }

    private void doStopPlaying() {
        if (this.playerThread != null) {
            this.playerThread.stopMod();
            this.playerThread = null;
        }
    }

    private Mixer createNewMixer() {
        Mixer mixer = this.currentContainer.createNewMixer();
        return mixer;
    }

    private void loadMultimediaOrPlayListFile(URL mediaPLSFileURL) {
        this.currentPlayList = null;
        try {
            String checkPLS = mediaPLSFileURL.getPath().toLowerCase();
            if (checkPLS.endsWith(".pls") || checkPLS.endsWith(".m3u")) {
                this.currentPlayList = PlayList.createFromFile(mediaPLSFileURL, this.shuffle);
                if (this.currentPlayList.next()) {
                    mediaPLSFileURL = this.currentPlayList.getCurrentEntry().getFile();
                }
            }
            if (mediaPLSFileURL != null) {
                this.loadMultimediaFile(mediaPLSFileURL);
            }
        }
        catch (Throwable ex) {
            Log.error("[MainForm::loadMultimediaOrPlayListFile]", ex);
            this.currentPlayList = null;
        }
    }

    private void loadMultimediaFile(URL mediaFileURL) {
        try {
            try {
                if (mediaFileURL != null) {
                    this.currentContainer = MultimediaContainerManager.getMultimediaContainer(mediaFileURL);
                }
            }
            catch (Throwable ex) {
                Log.error("[MainForm::loadMultimediaFile]", ex);
                this.currentContainer = null;
                if (this.playerThread != null) {
                    this.doStartPlaying();
                }
            }
        }
        finally {
            if (this.playerThread != null) {
                this.doStartPlaying();
            }
        }
    }

    public static void main(String[] args) {
        block4: {
            Log.info("Java Mod Player V1.9.3.4 \u00a9 by Daniel Becker 2006/07/08/09/10\n");
            try {
                if (args.length == 0) {
                    CommandLine.showHelp();
                    break block4;
                }
                CommandLine me = new CommandLine();
                me.parseParameters(args);
                me.loadMultimediaOrPlayListFile(me.modFileName);
                me.doStartPlaying();
                while (true) {
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                Log.error("Error occured:", ex);
                CommandLine.showHelp();
                System.exit(-1);
            }
        }
    }
}

