/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io.wav;

import de.quippy.javamod.io.wav.RiffFile;
import java.io.File;
import javax.sound.sampled.AudioFormat;

public class WaveFile
extends RiffFile {
    private WaveFormat_Chunk wave_format = new WaveFormat_Chunk();
    private RiffFile.RiffChunkHeader pcm_data = new RiffFile.RiffChunkHeader();
    private long pcm_data_offset;

    public WaveFile() {
        this.pcm_data.ckID = WaveFile.fourCC("data");
        this.pcm_data.ckSize = 0;
    }

    public int openForWrite(File file, AudioFormat format) {
        return this.openForWrite(file.getAbsolutePath(), (int)format.getSampleRate(), (short)format.getSampleSizeInBits(), (short)format.getChannels());
    }

    public int openForWrite(String Filename, WaveFile OtherWave) {
        return this.openForWrite(Filename, OtherWave.getSamplingRate(), OtherWave.getBitsPerSample(), OtherWave.getNumChannels());
    }

    public int openForWrite(String Filename, int SamplingRate, short BitsPerSample, short NumChannels) {
        byte[] theWave;
        if (Filename == null) {
            return 4;
        }
        this.wave_format.data.config(SamplingRate, BitsPerSample, NumChannels);
        int retcode = this.open(Filename, 1);
        if (retcode == 0 && (retcode = this.write(theWave = new byte[]{87, 65, 86, 69}, 4)) == 0) {
            this.writeHeader(this.wave_format.header);
            this.write(this.wave_format.data.wFormatTag, 2);
            this.write(this.wave_format.data.nChannels, 2);
            this.write(this.wave_format.data.nSamplesPerSec, 4);
            this.write(this.wave_format.data.nAvgBytesPerSec, 4);
            this.write(this.wave_format.data.nBlockAlign, 2);
            this.write(this.wave_format.data.nBitsPerSample, 2);
            if (retcode == 0) {
                this.pcm_data_offset = this.currentFilePosition();
                retcode = this.writeHeader(this.pcm_data);
            }
        }
        return retcode;
    }

    public int writeSamples(byte[] data, int start, int numBytes) {
        this.pcm_data.ckSize += numBytes;
        return this.write(data, start, numBytes);
    }

    public int writeSamples(byte[] data, int numBytes) {
        this.pcm_data.ckSize += numBytes;
        return this.write(data, numBytes);
    }

    public int writeSamples(short[] data, int numSamples) {
        int numBytes = numSamples << 1;
        byte[] theData = new byte[numBytes];
        int y = 0;
        int yc = 0;
        while (y < numBytes) {
            theData[y] = (byte)(data[yc] & 0xFF);
            theData[y + 1] = (byte)(data[yc++] >>> 8 & 0xFF);
            y += 2;
        }
        return this.write(theData, numBytes);
    }

    public int close() {
        int rc = 0;
        if (this.fmode == 1) {
            rc = this.backpatchHeader(this.pcm_data_offset, this.pcm_data);
        }
        rc = super.close();
        return rc;
    }

    public int getSamplingRate() {
        return this.wave_format.data.nSamplesPerSec;
    }

    public short getBitsPerSample() {
        return this.wave_format.data.nBitsPerSample;
    }

    public short getNumChannels() {
        return this.wave_format.data.nChannels;
    }

    class WaveFormat_Chunk {
        public RiffFile.RiffChunkHeader header = new RiffFile.RiffChunkHeader();
        public WaveFormat_ChunkData data;

        public WaveFormat_Chunk() {
            this.header.ckID = WaveFile.fourCC("fmt ");
            this.header.ckSize = 16;
            this.data = new WaveFormat_ChunkData();
        }
    }

    class WaveFormat_ChunkData {
        public short wFormatTag = 1;
        public short nChannels;
        public int nSamplesPerSec;
        public int nAvgBytesPerSec;
        public short nBlockAlign;
        public short nBitsPerSample;

        public WaveFormat_ChunkData() {
            this.config(44100, (short)16, (short)1);
        }

        public void config(int NewSamplingRate, short NewBitsPerSample, short NewNumChannels) {
            this.nSamplesPerSec = NewSamplingRate;
            this.nChannels = NewNumChannels;
            this.nBitsPerSample = NewBitsPerSample;
            this.nAvgBytesPerSec = this.nChannels * this.nSamplesPerSec * this.nBitsPerSample / 8;
            this.nBlockAlign = (short)(this.nChannels * this.nBitsPerSample / 8);
        }
    }
}

