/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io.wav;

import java.io.IOException;
import java.io.RandomAccessFile;

public class RiffFile {
    public static final int DDC_SUCCESS = 0;
    public static final int DDC_FAILURE = 1;
    public static final int DDC_OUT_OF_MEMORY = 2;
    public static final int DDC_FILE_ERROR = 3;
    public static final int DDC_INVALID_CALL = 4;
    public static final int DDC_USER_ABORT = 5;
    public static final int DDC_INVALID_FILE = 6;
    public static final int RFM_UNKNOWN = 0;
    public static final int RFM_WRITE = 1;
    public static final int RFM_READ = 2;
    private RiffChunkHeader riff_header = new RiffChunkHeader();
    protected int fmode = 0;
    protected RandomAccessFile file = null;

    public RiffFile() {
        this.riff_header.ckID = RiffFile.fourCC("RIFF");
        this.riff_header.ckSize = 0;
    }

    public int currentFileMode() {
        return this.fmode;
    }

    public int open(String Filename, int NewMode) {
        int retcode = 0;
        if (this.fmode != 0) {
            retcode = this.close();
        }
        if (retcode == 0) {
            switch (NewMode) {
                case 1: {
                    try {
                        this.file = new RandomAccessFile(Filename, "rw");
                        this.fmode = 1;
                        if (this.writeHeader_internally(this.riff_header) == 0) break;
                        this.file.close();
                        this.fmode = 0;
                    }
                    catch (IOException ioe) {
                        this.fmode = 0;
                        retcode = 3;
                    }
                    break;
                }
                case 2: {
                    try {
                        this.file = new RandomAccessFile(Filename, "r");
                        try {
                            byte[] br = new byte[8];
                            this.file.read(br, 0, 8);
                            this.fmode = 2;
                            this.riff_header.ckID = br[0] << 24 & 0xFF000000 | br[1] << 16 & 0xFF0000 | br[2] << 8 & 0xFF00 | br[3] & 0xFF;
                            this.riff_header.ckSize = br[7] << 24 & 0xFF000000 | br[6] << 16 & 0xFF0000 | br[5] << 8 & 0xFF00 | br[4] & 0xFF;
                        }
                        catch (IOException ioe) {
                            this.file.close();
                            this.fmode = 0;
                        }
                    }
                    catch (IOException ioe) {
                        this.fmode = 0;
                        retcode = 3;
                    }
                    break;
                }
                default: {
                    retcode = 4;
                }
            }
        }
        return retcode;
    }

    public int write(byte[] data, int numBytes) {
        return this.write(data, 0, numBytes);
    }

    public int write(byte[] data, int start, int numBytes) {
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.write(data, start, numBytes);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riff_header.ckSize += numBytes - start;
        return 0;
    }

    public int writeHeader_internally(RiffChunkHeader hriff_header) {
        byte[] br = new byte[8];
        br[0] = (byte)(hriff_header.ckID >>> 24 & 0xFF);
        br[1] = (byte)(hriff_header.ckID >>> 16 & 0xFF);
        br[2] = (byte)(hriff_header.ckID >>> 8 & 0xFF);
        br[3] = (byte)(hriff_header.ckID & 0xFF);
        br[7] = (byte)(hriff_header.ckSize >>> 24 & 0xFF);
        br[6] = (byte)(hriff_header.ckSize >>> 16 & 0xFF);
        br[5] = (byte)(hriff_header.ckSize >>> 8 & 0xFF);
        br[4] = (byte)(hriff_header.ckSize & 0xFF);
        try {
            this.file.write(br, 0, 8);
        }
        catch (IOException ioe) {
            return 3;
        }
        return 0;
    }

    public int writeHeader(RiffChunkHeader hriff_header) {
        if (this.fmode != 1) {
            return 4;
        }
        int status = this.writeHeader_internally(hriff_header);
        if (status == 0) {
            this.riff_header.ckSize += 8;
        }
        return status;
    }

    public int write(short Data, int NumBytes) {
        short theData = (short)(Data >>> 8 & 0xFF | Data << 8 & 0xFF00);
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeShort(theData);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riff_header.ckSize += NumBytes;
        return 0;
    }

    public int write(int Data, int NumBytes) {
        short theDataL = (short)(Data >>> 16 & 0xFFFF);
        short theDataR = (short)(Data & 0xFFFF);
        short theDataLI = (short)(theDataL >>> 8 & 0xFF | theDataL << 8 & 0xFF00);
        short theDataRI = (short)(theDataR >>> 8 & 0xFF | theDataR << 8 & 0xFF00);
        int theData = theDataRI << 16 & 0xFFFF0000 | theDataLI & 0xFFFF;
        if (this.fmode != 1) {
            return 4;
        }
        try {
            this.file.writeInt(theData);
            this.fmode = 1;
        }
        catch (IOException ioe) {
            return 3;
        }
        this.riff_header.ckSize += NumBytes;
        return 0;
    }

    public int read(byte[] Data, int NumBytes) {
        int retcode = 0;
        try {
            this.file.read(Data, 0, NumBytes);
        }
        catch (IOException ioe) {
            retcode = 3;
        }
        return retcode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int expect(String Data, int NumBytes) {
        byte target = 0;
        int cnt = 0;
        try {
            do {
                if (NumBytes-- != 0) continue;
                return 0;
            } while ((target = this.file.readByte()) == Data.charAt(cnt++));
            return 3;
        }
        catch (IOException ioe) {
            return 3;
        }
    }

    public int close() {
        int retcode = 0;
        switch (this.fmode) {
            case 1: {
                try {
                    this.file.seek(0L);
                    try {
                        this.writeHeader_internally(this.riff_header);
                        this.file.close();
                    }
                    catch (IOException ioe) {
                        retcode = 3;
                    }
                }
                catch (IOException ioe) {
                    retcode = 3;
                }
                break;
            }
            case 2: {
                try {
                    this.file.close();
                    break;
                }
                catch (IOException ioe) {
                    retcode = 3;
                }
            }
        }
        this.file = null;
        this.fmode = 0;
        return retcode;
    }

    public long currentFilePosition() {
        long position;
        try {
            position = this.file.getFilePointer();
        }
        catch (IOException ioe) {
            position = -1L;
        }
        return position;
    }

    public int backpatchHeader(long FileOffset, RiffChunkHeader data) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(FileOffset);
        }
        catch (IOException ioe) {
            return 3;
        }
        return this.writeHeader_internally(data);
    }

    public int backpatch(long FileOffset, byte[] Data, int NumBytes) {
        if (this.file == null) {
            return 4;
        }
        try {
            this.file.seek(FileOffset);
        }
        catch (IOException ioe) {
            return 3;
        }
        return this.write(Data, NumBytes);
    }

    protected int seek(long offset) {
        int rc;
        try {
            this.file.seek(offset);
            rc = 0;
        }
        catch (IOException ioe) {
            rc = 3;
        }
        return rc;
    }

    public static int fourCC(String ChunkName) {
        byte[] p = new byte[]{32, 32, 32, 32};
        System.arraycopy(ChunkName.getBytes(), 0, p, 0, 4);
        int ret = p[0] << 24 & 0xFF000000 | p[1] << 16 & 0xFF0000 | p[2] << 8 & 0xFF00 | p[3] & 0xFF;
        return ret;
    }

    protected static class RiffChunkHeader {
        public int ckID = 0;
        public int ckSize = 0;
    }
}

