/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.SoundOutputStream;
import de.quippy.javamod.io.wav.WaveFile;
import de.quippy.javamod.mixer.dsp.AudioProcessor;
import de.quippy.javamod.system.Log;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;

public class SoundOutputStreamImpl
implements SoundOutputStream {
    private AudioProcessor audioProcessor;
    private AudioFormat audioFormat;
    private File exportFile;
    private SourceDataLine sourceLine;
    private WaveFile waveExportFile;
    private boolean playDuringExport;
    private boolean keepSilent;

    public SoundOutputStreamImpl(AudioFormat audioFormat, AudioProcessor audioProcessor, File exportFile, boolean playDuringExport, boolean keepSilent) {
        this.audioFormat = audioFormat;
        this.audioProcessor = audioProcessor;
        this.exportFile = exportFile;
        this.playDuringExport = playDuringExport;
        this.keepSilent = keepSilent;
    }

    private void openSourceLine() {
        if (this.audioFormat != null) {
            try {
                DataLine.Info sourceLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
                if (AudioSystem.isLineSupported(sourceLineInfo)) {
                    this.sourceLine = (SourceDataLine)AudioSystem.getLine(sourceLineInfo);
                    this.sourceLine.open();
                    this.sourceLine.start();
                } else {
                    Log.info("Audioformat is not supported");
                }
            }
            catch (Exception ex) {
                this.sourceLine = null;
                Log.error("Error occured when opening audio device", ex);
            }
        }
    }

    private void openAudioProcessor() {
        if (this.audioProcessor != null && this.sourceLine != null) {
            this.audioProcessor.initializeProcessor(this.sourceLine);
            this.audioProcessor.setUseInternalCounter(this.keepSilent);
        }
    }

    private void openExportFile() {
        if (this.exportFile != null) {
            this.waveExportFile = new WaveFile();
            if (this.waveExportFile.openForWrite(this.exportFile, this.audioFormat) != 0) {
                this.waveExportFile = null;
                Log.error("Creation of exportfile was NOT successfull!");
            }
        }
    }

    private void closeSourceLine() {
        if (this.sourceLine != null) {
            this.stopLine();
            this.sourceLine.close();
            this.sourceLine = null;
        }
    }

    private void closeAudioProcessor() {
        if (this.audioProcessor != null) {
            this.audioProcessor.stop();
        }
    }

    private void closeExportFile() {
        if (this.waveExportFile != null) {
            this.waveExportFile.close();
        }
    }

    public synchronized void open() {
        this.close();
        if (this.playDuringExport || this.exportFile == null) {
            this.openSourceLine();
        }
        this.openAudioProcessor();
        this.openExportFile();
    }

    public synchronized void close() {
        this.closeSourceLine();
        this.closeAudioProcessor();
        this.closeExportFile();
    }

    public synchronized boolean isInitialized() {
        return this.sourceLine != null || this.exportFile != null;
    }

    public synchronized void startLine() {
        if (this.sourceLine != null) {
            this.sourceLine.flush();
            this.sourceLine.start();
        }
    }

    public synchronized void stopLine() {
        if (this.sourceLine != null) {
            if (this.sourceLine.isRunning()) {
                this.sourceLine.drain();
            }
            this.sourceLine.stop();
        }
    }

    public synchronized void writeSampleData(byte[] samples, int start, int length) {
        if (this.sourceLine != null && !this.keepSilent) {
            this.sourceLine.write(samples, start, length);
        }
        if (this.waveExportFile != null) {
            this.waveExportFile.writeSamples(samples, start, length);
        }
    }

    public synchronized void writeDSPData(int[] dspOutput, int start, int length) {
        if (this.audioProcessor != null && this.sourceLine != null) {
            this.audioProcessor.writeSampleData(dspOutput, start, length);
        }
    }

    public void setInternalFramePosition(long newFramePosition) {
        if (this.audioProcessor != null && this.sourceLine != null) {
            this.audioProcessor.setInternalFramePosition(newFramePosition);
        }
    }

    public void setVolume(double gain) {
        if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl gainControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.MASTER_GAIN);
            float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
        }
    }

    public void setBalance(float balance) {
        if (this.sourceLine != null && this.sourceLine.isControlSupported(FloatControl.Type.BALANCE)) {
            FloatControl balanceControl = (FloatControl)this.sourceLine.getControl(FloatControl.Type.BALANCE);
            balanceControl.setValue(balance);
        }
    }
}

