/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.RandomAccessInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class RandomAccessInputStreamImpl
extends InputStream
implements RandomAccessInputStream {
    private RandomAccessFile raFile;
    private File tmpFile;
    private int mark;
    private byte[] buffer;
    private int readPointer;
    private int bufferLength;

    public RandomAccessInputStreamImpl(File file) throws FileNotFoundException {
        this.raFile = new RandomAccessFile(file, "r");
        this.tmpFile = null;
    }

    public RandomAccessInputStreamImpl(String fileName) throws FileNotFoundException {
        this(new File(fileName));
    }

    public RandomAccessInputStreamImpl(URL fromUrl) throws IOException, FileNotFoundException, MalformedURLException {
        if (fromUrl.getProtocol().equalsIgnoreCase("file")) {
            try {
                this.tmpFile = null;
                File file = new File(fromUrl.toURI());
                this.raFile = new RandomAccessFile(file, "r");
            }
            catch (URISyntaxException uriEx) {
                throw new MalformedURLException(uriEx.getMessage());
            }
        }
        URLConnection con = fromUrl.openConnection();
        InputStream inputStream = con.getInputStream();
        try {
            this.tmpFile = File.createTempFile("JavaMod", "ReadFile");
            this.tmpFile.deleteOnExit();
            FileOutputStream out = new FileOutputStream(this.tmpFile);
            this.copyFullStream(inputStream, out);
            inputStream.close();
            out.close();
            this.raFile = new RandomAccessFile(this.tmpFile, "r");
            this.buffer = null;
        }
        catch (Exception ex) {
            int size = con.getContentLength();
            if (size < 0) {
                size = 32;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            this.copyFullStream(inputStream, out);
            inputStream.close();
            out.close();
            this.buffer = out.toByteArray();
            this.bufferLength = this.buffer.length;
            this.readPointer = 0;
            this.raFile = null;
        }
    }

    private void copyFullStream(InputStream inputStream, OutputStream out) throws IOException {
        int len;
        byte[] input = new byte[8192];
        while ((len = inputStream.read(input, 0, 8192)) != -1) {
            out.write(input, 0, len);
        }
    }

    public int available() throws IOException {
        if (this.raFile != null) {
            return (int)(this.raFile.length() - this.raFile.getFilePointer());
        }
        return this.bufferLength - this.readPointer;
    }

    public void close() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
        }
        super.close();
        if (this.tmpFile != null) {
            this.tmpFile.delete();
        }
    }

    public synchronized void mark(int readlimit) {
        try {
            this.mark = this.raFile != null ? (int)this.raFile.getFilePointer() : this.readPointer;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.raFile != null) {
            return this.raFile.read();
        }
        return this.readPointer < this.bufferLength ? this.buffer[this.readPointer++] & 0xFF : -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.raFile != null) {
            return this.raFile.read(b, off, len);
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readPointer >= this.bufferLength) {
            return -1;
        }
        if (this.readPointer + len > this.bufferLength) {
            len = this.bufferLength - this.readPointer;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.readPointer, b, off, len);
        this.readPointer += len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(this.mark);
        } else {
            this.readPointer = this.mark;
        }
    }

    public long skip(long n) throws IOException {
        if (this.raFile != null) {
            return this.raFile.skipBytes((int)n);
        }
        if ((long)this.readPointer + n > (long)this.bufferLength) {
            n = this.bufferLength - this.readPointer;
        }
        if (n < 0L) {
            return 0L;
        }
        this.readPointer = (int)((long)this.readPointer + n);
        return n;
    }

    public long getFilePointer() throws IOException {
        if (this.raFile != null) {
            return this.raFile.getFilePointer();
        }
        return this.readPointer;
    }

    public void seek(long pos) throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(pos);
        } else {
            this.readPointer = (int)pos;
        }
    }

    public byte readByte() throws IOException {
        if (this.raFile != null) {
            return this.raFile.readByte();
        }
        return (byte)this.read();
    }

    public long getLength() throws IOException {
        if (this.raFile != null) {
            return this.raFile.length();
        }
        return this.bufferLength;
    }
}

