/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PowerPackerRandomAccessStream
extends InputStream
implements RandomAccessInputStream {
    private byte[] buffer;
    private int bufferLength;
    private int readPointer;
    private int mark;

    public PowerPackerRandomAccessStream(RandomAccessInputStream input) throws IOException {
        this.buffer = this.readAndUnpack(input);
        this.bufferLength = this.buffer.length;
        this.readPointer = 0;
        this.mark = -1;
    }

    private void pp20DoUnpack(RandomAccessInputStream source, byte[] buffer) throws IOException {
        BitBuffer bitBuffer = new BitBuffer(source, (int)source.getLength() - 4);
        source.seek(source.getLength() - 1L);
        int skip = source.read();
        bitBuffer.getBits(skip);
        int nBytesLeft = buffer.length;
        block0: while (nBytesLeft > 0) {
            int nofs;
            int n;
            if (bitBuffer.getBits(1) == 0) {
                n = 1;
                while (n < nBytesLeft) {
                    int code = bitBuffer.getBits(2);
                    n += code;
                    if (code != 3) break;
                }
                int i = 0;
                while (i < n) {
                    buffer[--nBytesLeft] = (byte)bitBuffer.getBits(8);
                    ++i;
                }
                if (nBytesLeft == 0) break;
            }
            n = bitBuffer.getBits(2) + 1;
            source.seek(n + 3);
            int nbits = source.read();
            if (n == 4) {
                nofs = bitBuffer.getBits(bitBuffer.getBits(1) != 0 ? nbits : 7);
                while (n < nBytesLeft) {
                    int code = bitBuffer.getBits(3);
                    n += code;
                    if (code == 7) {
                        continue;
                    }
                    break;
                }
            } else {
                nofs = bitBuffer.getBits(nbits);
            }
            int i = 0;
            while (i <= n) {
                byte by = buffer[nBytesLeft - 1] = nBytesLeft + nofs < buffer.length ? buffer[nBytesLeft + nofs] : (byte)0;
                if (--nBytesLeft == 0) continue block0;
                ++i;
            }
        }
    }

    private byte[] readAndUnpack(RandomAccessInputStream source) throws IOException {
        source.seek(0L);
        int PP20ID = source.read() << 24 | source.read() << 16 | source.read() << 8 | source.read();
        int length = (int)source.getLength();
        if (length < 256 || PP20ID != 1347433008) {
            throw new IOException("Not a powerpacker file!");
        }
        source.seek(length - 4);
        int destLen = source.read() << 16 | source.read() << 8 | source.read();
        if (destLen < 512 || destLen > 0x400000 || destLen > length << 3) {
            throw new IOException("Length of " + length + " is not supported!");
        }
        byte[] dstBuffer = new byte[destLen];
        this.pp20DoUnpack(source, dstBuffer);
        return dstBuffer;
    }

    public int available() throws IOException {
        return this.bufferLength - this.readPointer;
    }

    public void close() throws IOException {
        super.close();
        this.buffer = null;
        this.readPointer = 0;
        this.mark = -1;
    }

    public long getFilePointer() throws IOException {
        return this.readPointer;
    }

    public long getLength() throws IOException {
        return this.bufferLength;
    }

    public synchronized void mark(int readlimit) {
        this.mark = this.readPointer;
    }

    public boolean markSupported() {
        return true;
    }

    public byte readByte() throws IOException {
        return this.readPointer < this.bufferLength ? this.buffer[this.readPointer++] : (byte)-1;
    }

    public int read() throws IOException {
        return this.readByte();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readPointer >= this.bufferLength) {
            return -1;
        }
        if (this.readPointer + len > this.bufferLength) {
            len = this.bufferLength - this.readPointer;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buffer, this.readPointer, b, off, len);
        this.readPointer += len;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        if (this.mark != -1) {
            this.readPointer = this.mark;
        }
    }

    public void seek(long pos) throws IOException {
        this.readPointer = (int)pos;
    }

    public long skip(long n) throws IOException {
        if ((long)this.readPointer + n > (long)this.bufferLength) {
            n = this.bufferLength - this.readPointer;
        }
        if (n < 0L) {
            return 0L;
        }
        this.readPointer = (int)((long)this.readPointer + n);
        return n;
    }

    private static class BitBuffer {
        private RandomAccessInputStream source;
        private int filePointer;
        private int bitCount;
        private int bitBuffer;

        public BitBuffer(RandomAccessInputStream source, int filePointer) {
            this.source = source;
            this.filePointer = filePointer;
            this.bitCount = 0;
            this.bitBuffer = 0;
        }

        public int getBits(int n) throws IOException {
            int result = 0;
            int i = 0;
            while (i < n) {
                if (this.bitCount == 0) {
                    this.bitCount = 8;
                    if (this.filePointer > 3) {
                        --this.filePointer;
                    }
                    this.source.seek(this.filePointer);
                    this.bitBuffer = this.source.read();
                }
                result = result << 1 | this.bitBuffer & 1;
                this.bitBuffer >>= 1;
                --this.bitCount;
                ++i;
            }
            return result;
        }
    }
}

