/*
 * Decompiled with CFR 0.152.
 */
package de.quippy.javamod.io;

import de.quippy.javamod.io.PowerPackerRandomAccessStream;
import de.quippy.javamod.io.RandomAccessInputStream;
import de.quippy.javamod.io.RandomAccessInputStreamImpl;
import de.quippy.javamod.system.Helpers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class ModfileInputStream
extends InputStream {
    private RandomAccessInputStream randomAccessInputStream;
    private String fileName;

    public ModfileInputStream(RandomAccessInputStream input) throws IOException {
        this.randomAccessInputStream = input;
        if (this.isPowerPacker()) {
            this.randomAccessInputStream = new PowerPackerRandomAccessStream(input);
        }
    }

    public ModfileInputStream(File file) throws FileNotFoundException, IOException {
        this(new RandomAccessInputStreamImpl(file));
        this.fileName = file.getAbsolutePath();
    }

    public ModfileInputStream(String fileName) throws FileNotFoundException, IOException {
        this(new RandomAccessInputStreamImpl(fileName));
        this.fileName = fileName;
    }

    public ModfileInputStream(URL fromUrl) throws IOException, FileNotFoundException, MalformedURLException {
        this(new RandomAccessInputStreamImpl(fromUrl));
        try {
            this.fileName = URLDecoder.decode(fromUrl.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.fileName = fromUrl.getPath();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private boolean isPowerPacker() throws IOException {
        long pos = this.getFilePointer();
        this.seek(0L);
        String ppId = this.readString(4);
        this.seek(pos);
        return ppId.equals("PP20");
    }

    public int available() throws IOException {
        return this.randomAccessInputStream.available();
    }

    public void close() throws IOException {
        this.randomAccessInputStream.close();
    }

    public synchronized void mark(int readlimit) {
        this.randomAccessInputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.randomAccessInputStream.markSupported();
    }

    public int read() throws IOException {
        return this.randomAccessInputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.randomAccessInputStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.randomAccessInputStream.read(b);
    }

    public synchronized void reset() throws IOException {
        this.randomAccessInputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.randomAccessInputStream.skip(n);
    }

    public long getFilePointer() throws IOException {
        return this.randomAccessInputStream.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.randomAccessInputStream.seek(pos);
    }

    public byte readByte() throws IOException {
        return this.randomAccessInputStream.readByte();
    }

    public long getLength() throws IOException {
        return this.randomAccessInputStream.getLength();
    }

    public String readString(int strLength) throws IOException {
        byte[] buffer = new byte[strLength];
        int read = this.read(buffer, 0, strLength);
        return Helpers.retrieveAsString(buffer, 0, read);
    }

    public int readByteAsInt() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readMotorolaWord() throws IOException {
        return (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8;
    }

    public int readMotorolaDWord() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readIntelDWord() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }
}

